'''
Car diagnoistics program by Goldfish.
Used to find info about a DTR2 Car.
Made in Python 2.7.
'''
import os, glob, shutil

carStrDir = raw_input("Input path to car.str: ")
dataDir = "data"
paramDir = "default"

os.chdir(carStrDir)

for file in glob.glob("car.str"):
    print("Found required str file.\n")

print("Creating txt file.")
shutil.copy2("car.str", "car.txt")

if os.path.isfile("car.txt"):
    print(".str export successful, attempting to print car info.\n")
else:
    print("Whoops. That didn't work.")

with open("car.txt", "r") as carTxt:
    for line in carTxt:
        if ";" in line:
            print(line)
        elif "class = " in line:
            print(line)
        elif "english = " in line:
            print(line)
        elif "max horse power = " in line:
            print(line)
        elif "top speed = " in line:
            print(line)
        elif "zero to sixty = " in line:
            print(line)
        elif "[numbers]" in line:
            print("Car does have numbers.")
print("\n--------------------------------")
print("\nCar info printed, car.txt now viewable.")
print("\n------STARTING PARAMS.STR SCAN---------\n")


os.chdir(dataDir)
os.chdir(paramDir)

for file in glob.glob("params.str"):
    print("Found required str file.\n")

print("Creating txt file.")
shutil.copy2("params.str", "params.txt")

if os.path.isfile("params.txt"):
     print(".str export successful, attempting to print car info.\n")
else:
    print("Whoops, that didn't work.")

with open("params.txt", "r") as paramTxt:
    for line in paramTxt:
        if "acceleration factor = " in line:
            print(line)
        elif "mass = " in line:
            print(line)
        elif "wheel inertia = " in line:
            print(line)
        elif "tyre width = " in line:
            print(line)
print("\nCar info printed, params.txt now viewable in data/default.")
