unit endfuncu;

// Copyright  2001 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface
USES Windows, Registry, messages, sysutils, classes;
const
  exterm_OK                     = 00;
  exterm_openprocess            = 01;
  exterm_terminateprocess       = 02;
  exterm_terminatefailed        = 03;
  exterm_openprocesstoken       = 04;
  exterm_duplicatehandle        = 05;
  exterm_createremotethread     = 06;
  exterm_LookupPrivilegeValue   = 07;
  exterm_AdjustTokenPrivileges1 = 08;
  exterm_AdjustTokenPrivileges2 = 09;
  exterm_beg                = exterm_openprocess;
  exterm_end                = exterm_AdjustTokenPrivileges2;
  exterm_message : ARRAY[exterm_beg..exterm_end] OF String =
    ('Call to OpenProcess fonction failed',
    'Call to TerminateProcess function failed',
    'All functions succeeded, but process was not killed',
    'Call to OpenProcessToken function failed',
    'Call to DuplicateHandle function failed',
    'Call to CreateRemoteThread function failed',
    'Call to LookupPrivilegeValue function failed',
    'Call #1 to AdjustTokenPrivileges function failed',
    'Call #2 to AdjustTokenPrivileges2 function failed'
    );

procedure GetProcsAndWindows(SL : TStrings);
function Exterminate(pid : DWord) : Integer;
function IsExplorerWindow(weH : HWnd) : Boolean;
procedure RedrawSystray;
function IsServiceProcess(PID : DWORD) : Boolean;
procedure MakeServiceProcess(PID : DWORD; Make : Boolean);
function CanBlockPower : Boolean;
procedure DoBlockPower(block : Boolean);
function UseSaverActive : Boolean;
function GetSaverActive : Boolean;
procedure SetSaverActive(Active : Boolean);

VAR
  IsWinNt : Boolean;

implementation

uses tlhelp32, reobjs;

type
  RegisterServiceProcessType = function(dwProcessID, dwType: DWord) : DWord;
    stdcall;
  GetProcessFlagsType = function (processid: DWORD) : DWord;
    stdCall;
  SetThreadExecutionStateType = function(ExecutionState : DWORD) : DWord;
    stdcall;
const
  RSPSIMPLESERVICE     = 1;
  RSPUNREGISTERSERVICE = 0;
VAR
  hkernel : THandle;
  RegisterServiceProcess : RegisterServiceProcessType;
  GetProcessFlags : GetProcessFlagsType;
  _SetThreadExecutionState : SetThreadExecutionStateType;

function ListWinProc(H : HWnd; SL : TStringList) : Bool; stdCall;
// For each visible top-level window, locate the object in SL
// that corresponds to its process and record window and its
// state in that object
VAR
  PID    : DWORD;
  idx    : Integer;
begin
  Result := True;
  GetWindowThreadProcessID(H, @PID);
  idx := SL.IndexOf(IntToHex(PID, 8));
  IF idx < 0 THEN Exit;
  WITH SL.Objects[idx] AS TProcWinObj DO
    AddHWnd(H);
end;

function EnumProcessModules(hProcess: THandle; hModules : Pointer;
  cb : DWORD; VAR cbReq : DWORD) : Bool; stdcall; external 'psapi.dll';
function EnumProcesses(hModules : Pointer; cb : DWORD;
  VAR cbReq : DWORD) : Bool; stdcall; external 'psapi.dll';
function GetModuleFileNameExW(hProcess : THandle; hModule : THandle;
  lpFilename : PWideChar; nSize : DWORD) : DWORD; stdcall;
  external 'psapi.dll';

procedure GetProcsAndWindows(SL : TStrings);
  procedure GetListOfProcs9x;
  VAR
    PI32  : TProcessentry32;
    hSnap : THandle;
  begin
    hSnap := CreateToolHelp32Snapshot(TH32CS_SNAPPROCESS, 0);
    IF hSnap = 0 THEN Exit;
    try
      PI32.dwSize := SizeOf(pi32);
      IF Process32First(hSnap, PI32) THEN
        REPEAT
          WITH PI32 DO
            IF th32ProcessID <> 0 THEN
              SL.AddObject(IntToHex(th32ProcessID, 8),
                TProcWinObj.Create(th32ProcessID, szExefile));
        UNTIL NOT Process32Next(hSnap, PI32);
    finally
      CloseHandle(hSnap);
    end;
  end;

  procedure GetListOfProcsNT;
  type
    EnumProcessModulesType = function(hProcess: THandle;
      hModules : Pointer; cb : DWORD; VAR
      cbReq : DWORD) : Bool; stdcall;
    EnumProcessesType = function(
      hModules : Pointer; cb : DWORD; VAR
      cbReq : DWORD) : Bool; stdcall;
    GetModuleFileNameExWType = function (hProcess : THandle;
      hModule : THandle; lpFilename : PWideChar; nSize :
      DWORD) : DWORD; stdcall;
  const siz = 4096;
  VAR
    EnumProcesses        : EnumProcessesType;
    EnumProcessModules   : EnumProcessModulesType;
    GetModuleFileNameExW : GetModuleFileNameExWType;
    LibH                 : hModule;
    ProcHan              : THandle;
    ProcIDs, ModHans     : ARRAY OF THandle;
    cb, cbReq, N         : DWORD;
    Buff                 : ARRAY[0..MAX_PATH] OF WideChar;

    procedure LoadOne(VAR P : Pointer; const S : String);
    const nf = 'Function %s not found in PSAPI.DLL';
    begin
      P := GetProcAddress(LibH, PChar(S));
      IF P = nil THEN Raise(Exception.CreateFmt(nf, [S]));
    end;
  begin
    LibH := LoadLibrary('psapi.dll');
    IF LibH <= 32 THEN
      Raise(Exception.Create('PSAPI.DLL: ' +
        SysErrorMessage(GetLastError)));
    LoadOne(@EnumProcessModules,   'EnumProcessModules');
    LoadOne(@EnumProcesses,        'EnumProcesses');
    LoadOne(@GetModuleFileNameExW, 'GetModuleFileNameExW');
    SetLength(ProcIDs, siz);
    cb    := siz;
    cbReq := 0;
    IF NOT EnumProcesses(ProcIDs, cb, cbReq) THEN
      Exit;
    SetLength(ProcIDs, cbReq DIV SizeOf(THandle));
    FOR N := 0 TO Length(ProcIDs)-1 DO
      begin
        ProcHan := OpenProcess(PROCESS_QUERY_INFORMATION OR
          PROCESS_VM_READ, False, ProcIDs[N]);
        // Some processes return a process handle of 0, e.g.
        // System Idle Process, DLLHOST.EXE. Skip these
        IF ProcHan = 0 THEN
          Continue;
        try
          cb    := siz;
          cbReq := 0;
          SetLength(ModHans, siz);
          IF NOT EnumProcessModules(ProcHan, ModHans, cb, cbReq) THEN
            Continue;
          GetModuleFileNameExW(ProcHan, ModHans[0], @Buff, MAX_PATH);
          SL.AddObject(IntToHex(ProcIDs[N], 8),
            TProcWinObj.Create(ProcIDs[N],  WideCharToString(Buff)));
        finally
          CloseHandle(ProcHan);
        end;
      end;
  end;

begin
  SL.Clear;
  IF IsWinNT  {AND (Win32MajorVersion < 5)} THEN
    GetListOfProcsNT
  ELSE GetListOfProcs9x;
  // Add information about visible windows to the list of processes
  EnumWindows(@ListWinproc, Integer(SL));
end;

function IsServiceProcess(PID : DWORD) : Boolean;
begin
  IF @GetProcessFlags = nil THEN
    Raise(Exception.Create('The IsServiceProcess function '+
      'can only be used under Windows 9x'));
  Result := GetProcessFlags(PID) AND $100 = $100;
end;

procedure MakeServiceProcess(PID : DWORD; Make : Boolean);
begin
  IF @RegisterServiceProcess = nil THEN
    Raise(Exception.Create('The MakeServiceProcess function '+
      'can only be used under Windows 9x'));
  IF Make THEN
    RegisterServiceProcess(GetCurrentProcessID,
      RSPSIMPLESERVICE)
  ELSE
    RegisterServiceProcess(GetCurrentProcessID,
      RSPUNREGISTERSERVICE);
end;

procedure RedrawSystray;
VAR
  WasPt    : TPoint;
  X, Y     : Integer;
  TrayHan  : HWnd;
  TrayRect : TRect;
begin
  GetCursorPos(WasPt);
  try
    TrayHan := FindWindowEx(FindWindowEx(GetDesktopWindow, 0,
      'Shell_TrayWnd', nil), 0, 'TrayNotifyWnd', nil);
    IF TrayHan = 0 THEN Exit;
    GetWindowRect(TrayHan, TrayRect);
    Y := TrayRect.Top;
    WHILE Y < TrayRect.Bottom DO
      begin
        X := TrayRect.Left;
        WHILE X < TrayRect.Right DO
          begin
            Sleep(2);
            SetCursorPos(X, Y);
            Inc(X, 8);
          end;
        Inc(Y, 8);
      end;
    InvalidateRect(TrayHan, nil, True);
    UpdateWindow(TrayHan);
  finally
    SetCursorPos(WasPt.X, WasPt.Y);
  end;
end;

function IsExplorerWindow(weH : HWnd) : Boolean;
VAR Buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  GetClassName(weH, buffer, MAX_PATH);
  Result := True;
  IF StrComp(buffer, 'ExploreWClass') = 0 THEN Exit;
  IF StrComp(buffer, 'CabinetWClass') = 0 THEN Exit;
  IF StrComp(buffer, 'IEFrame')       = 0 THEN Exit;
  Result := False;
end;

function SetPrivilege(
  hToken           : THandle;
  Privilege        : PChar; // Privilege to enable/disable
  bEnablePrivilege : BOOL   // TRUE to enable.  FALSE to disable
) : integer;
// Technique from Microsoft Knowledge Base article Q131065
// translated into Delphi by Neil J. Rubenking

VAR
  tp         : TOKEN_PRIVILEGES;
  luid       : TLargeInteger;
  tpPrevious : TOKEN_PRIVILEGES;
  cbPrevious : DWORD;
begin
  cbPrevious := sizeof(TOKEN_PRIVILEGES);
  Result := exterm_LookupPrivilegeValue;
  IF NOT LookupPrivilegeValue(nil, Privilege, luid) THEN
    Exit;
  //
  // first pass.  get current privilege setting
  //
  tp.PrivilegeCount           := 1;
  tp.Privileges[0].Luid       := luid;
  tp.Privileges[0].Attributes := 0;

  Result := exterm_AdjustTokenPrivileges1;
  AdjustTokenPrivileges(hToken, FALSE, tp, sizeof(TOKEN_PRIVILEGES),
    tpPrevious, cbPrevious);
  IF GetLastError() <> ERROR_SUCCESS THEN Exit;

  //
  // second pass.  set privilege based on previous setting
  //
  tpPrevious.PrivilegeCount       := 1;
  tpPrevious.Privileges[0].Luid   := luid;

  WITH tpPrevious.Privileges[0] DO
    IF bEnablePrivilege THEN
      Attributes := Attributes OR SE_PRIVILEGE_ENABLED
    ELSE
      Attributes := Attributes AND (NOT SE_PRIVILEGE_ENABLED);

  Result := exterm_AdjustTokenPrivileges2;
  AdjustTokenPrivileges(hToken, FALSE, tpPrevious, cbPrevious,
    nil, cbPrevious);
  IF GetLastError() <> ERROR_SUCCESS THEN Exit;
  Result := exterm_ok;
end;

function Exterminate(Pid : DWord) : Integer;
const
  SE_DEBUG_NAME = 'SeDebugPrivilege';
type
  ExitProcessType = procedure (uExitCode: UINT); stdcall;
VAR
  H           : THandle;
  HProcessDup : THandle;
  hRT         : THandle;
  dwTID       : DWORD;
  hkernel     : THandle;
  pfnExitProc : ExitProcessType;

  function WaitFlash(T : THandle) : Boolean;
  VAR Count : Integer;
  begin
    Result := WaitForSingleObject(T, 500) <> WAIT_TIMEOUT;
    IF NOT Result THEN
      begin
        Count := 0;
        REPEAT
          Inc(Count);
          Result := WaitForSingleObject(T, 500) <> WAIT_TIMEOUT;
        UNTIL Result OR (Count > 9);
      end;
  end;
VAR
  hToken : THandle;
begin
  IF NOT IsWinNT THEN // just terminate it
    begin
      H := OpenProcess(PROCESS_ALL_ACCESS, False, pid);
      IF H = 0 THEN
        Result := exterm_openprocess
      ELSE IF NOT TerminateProcess(H, 0) THEN
        Result := exterm_terminateprocess
      ELSE IF NOT WaitFlash(H) THEN
        Result := exterm_terminatefailed
      ELSE Result := exterm_OK;
      Exit;
    end;
  // Now the juicy WinNT stuff
  // Technique from Microsoft Knowledge Base article Q131065
  // gives our process DEBUG access
  IF NOT OpenProcessToken(GetCurrentProcess(),
    TOKEN_ADJUST_PRIVILEGES OR TOKEN_QUERY, hToken) THEN
    begin
      result := exterm_openprocesstoken;
      Exit;
    end;
  try
    Result := SetPrivilege(hToken, SE_DEBUG_NAME, True);
    IF Result <> exterm_OK THEN Exit;
    try
      result := exterm_openprocess;
      H := OpenProcess(PROCESS_ALL_ACCESS, False, pid);
      IF H = 0 THEN Exit;
      HProcessDup := INVALID_HANDLE_VALUE;
      dwTID       := 0;
      result      := exterm_duplicatehandle;
      IF NOT DuplicateHandle(GetCurrentProcess, H,
        GetCurrentProcess, @hProcessDup, PROCESS_ALL_ACCESS,
        FALSE, 0) THEN Exit;
      hKernel     := GetModuleHandle('Kernel32');
      pfnExitProc := GetProcAddress(hkernel, 'ExitProcess');
      hRT := CreateRemoteThread(hProcessDup, nil, 0,
        @pfnExitProc, nil, 0, dwTID);
      IF hRT = 0 THEN
        Result := exterm_createremotethread
      ELSE
        begin
          IF NOT (WaitFlash(hRT) OR
            (TerminateProcess(H, 0) AND WaitFlash(H))) THEN
            Result := exterm_terminatefailed
          ELSE Result := exterm_OK;
          CloseHandle(hRT);
        end;
    finally
      SetPrivilege(hToken, SE_DEBUG_NAME, False);
    end;
  finally
    CloseHandle(hToken);
  end;
end;

function CanBlockPower : Boolean;
begin
  Result := @_SetThreadExecutionState <> nil;
end;

procedure DoBlockPower(block : Boolean);
CONST
  ES_SYSTEM_REQUIRED  = $00000001;
  ES_DISPLAY_REQUIRED = $00000002;
  ES_USER_PRESENT     = $00000004;
  ES_CONTINUOUS       = $80000000;
begin
  IF @_SetThreadExecutionState = nil THEN Exit;
  IF block THEN
    _SetThreadExecutionState(ES_SYSTEM_REQUIRED OR
      ES_DISPLAY_REQUIRED OR ES_CONTINUOUS)
  ELSE
    _SetThreadExecutionState(ES_CONTINUOUS);
end;

procedure SetSaverActive(Active : Boolean);
begin
  IF Active THEN
    SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 1,
      nil, SPIF_SENDCHANGE OR SPIF_UPDATEINIFILE)
  ELSE
    SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 0,
      nil, SPIF_SENDCHANGE OR SPIF_UPDATEINIFILE);
end;

function UseSaverActive : Boolean;
begin
  IF Win32Platform = VER_PLATFORM_WIN32_NT THEN
    Result := Win32MajorVersion <= 4
  ELSE
    Result := (Win32MajorVersion = 4) AND
      (Win32MinorVersion < 10);
end;

function GetSaverActive : Boolean;
VAR Was : Bool;
begin
  SystemParametersInfo(SPI_GETSCREENSAVEACTIVE, 0, @Was, 0);
  Result := Was;
end;

initialization
  IsWinNT := Win32Platform = VER_PLATFORM_WIN32_NT;
  @RegisterServiceProcess   := nil;
  @GetProcessFlags          := nil;
  @_SetThreadExecutionState := nil;
  hKernel := GetModuleHandle('Kernel32');
  IF hKernel = 0 THEN Exit;
  _SetThreadExecutionState := GetProcAddress(hKernel,
    'SetThreadExecutionState');
  IF NOT IsWinNT THEN
    begin
      RegisterServiceProcess := GetProcAddress(hKernel,
        'RegisterServiceProcess');
      GetProcessFlags := GetProcAddress(hKernel,
        'GetProcessFlags');
    end;
end.

